## Setup Guide
The _HubSpot_ integration includes support for the following:

### Field Compatibility

HubSpot integration includes support for field mapping to standard and custom fields from all 3 endpoints listed below (of text/number string type only):

* [Deals](http://developers.hubspot.com/docs/methods/deals/deals_overview) (optional)
* [Contacts](http://developers.hubspot.com/docs/methods/contacts/contacts-overview)
* [Companies](http://developers.hubspot.com/docs/methods/companies/companies-overview)


### Duplicate Check & Update

A duplicate check on records is done in the following way:

1. Check whether the *Contact* already exists:
	* Check against **Email address** as the identifier.
	* If there's a match, update the *Contact* with new values, where supplied.
	* If no match, create a new HubSpot *Contact*.
2. Check whether the *Company* already exists:
	* Check against **Company domain name**, which is automatically generated by HubSpot from the *Contact* email address domain name.
	* If there's a match, update the *Company* with new values, where supplied.
	* If no match, create a new HubSpot *Company*.
	* If a new *Contact* was created, link the contact to the *Company*.
3. Create new *Deal*.
	* Attach the *Deal* to existing or newly created HubSpot *Company* and *Contact*.


### Setup Instructions

1. Create & get Private App token from HubSpot:
	* Open a new tab and go to [HubSpot](https://hubspot.com) and log into your account.
	* At the top right corner, click on the profile icon and select **Profile & Preferences**.
	* Click on the **Integrations** left navigation item, and then click on **Private Apps**.
	* Click the **Create a Private App** button.
	* In the next page, update the name and other information for the app as you wish.
	* Click on the **Scopes** tab at the top.
	* Then click on the **CRM** scope category and select _Write_ and _Read_ for:
		* `crm.objects.companies`
		* `crm.objects.contacts`
		* `crm.objects.deals`
	* Click the orange **Create app** button at the top right corner of the page.
	* When the modal loads with the private app token, copy that newly created token.
2. Setup Integration on your site:
	* Enter a name and handle for the integration.
	* Paste the HubSpot Private App token into the **Private App Token** field below.
	* Additional configuration:
		* **IP Address Field** (optional)
			* If you want to have the user's IP address sent over to the Contact in HubSpot, you can specify the custom HubSpot Contact field handle to receive it.
		* **Append checkbox group field values on Contact update?**
			* If a Contact already exists in HubSpot, enabling this will append additional checkbox group field values to the Contact inside HubSpot, instead of overwriting the options.
		* **Append checkbox group field values on Company update?**
			* If a Company already exists in HubSpot, enabling this will append additional checkbox group field values to the Company inside HubSpot, instead of overwriting the options.
	* Click the **Save** button.
3. Verify Authorization:
	* After the integration is saved, it'll return you to the list of CRM integrations.
	* Click into the newly created integration.
	* Confirm that there is green circle with **Authorized** in the middle of the page.
	* That's it! You can now use this integration inside the form builder.

---

<small>Do you need more from this integration? Is the integration you're looking for not here? Solspace offers [custom software development services](https://docs.solspace.com/support/premium/) to build any feature or change you need.</small>